#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_AntiseraWorklist : BaseTest 
	{
		private DataTable _dtAntiseraWorklist;
		private DataTable _dtAntiseraWorklistTyping;
		private System.Guid _antiseraWorklistGuid;
		private DataTable _dtReagent;
		private DataTable _dtBloodUnit;
		private DataTable _dtAntiseraUnitTest;
		private DataTable _dtRack;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//**Get AntiseraWorklistTyping data
				this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntiseraWorklistTyping AWT JOIN AntiseraUnitTest AUT ON AWT.AntiseraWorklistTypingGuid = AUT.AntiseraWorklistTypingGuid JOIN AntiseraWorklist AW ON AWT.AntiseraWorklistGuid = AWT.AntiseraWorklistGuid WHERE AW.RecordStatusCode = 'A' AND AW.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				this._antiseraWorklistGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid];

				//**Get AntiseraWork data
				this._dtAntiseraWorklist = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntiseraWorklist WHERE AntiseraWorklistGuid = '" + this._antiseraWorklistGuid.ToString() + "'", true);

				//**Get Reagent data (for Saves/Updates)
				this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND Divisioncode = '" + UnitTestConfig.TestDivisionCode + "' AND LotExpirationDate IS NOT NULL", true);

				//**Get Reagent data (for Saves/Updates)
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND Divisioncode = '" + UnitTestConfig.TestDivisionCode + "'",  true);

				//**Get Rack data (for Saves/Updates) -- don't raise exception, so we can create data if needbe
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND Divisioncode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtRack.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("UPDATE Rack SET RecordStatusCode = 'A' WHERE DailyControlGuid IN (SELECT TOP 1 DailyControlGUid FROM Rack WHERE DailyControlGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "')");
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND Divisioncode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}
		
				//**Get AntiseraUnitTest data (for Updates)
				this._dtAntiseraUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntiseraUnitTest WHERE AntiseraWorklistTypingGuid = '" + this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid].ToString() + "'", true);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetAntiseraWorklistByGuid_Pass()
		{
			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistByGuid(this._antiseraWorklistGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.AntiseraWorklistGuid), TABLES.AntiseraWorklist.AntiseraWorklistGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.WorklistCreateDate), TABLES.AntiseraWorklist.WorklistCreateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.WorklistName), TABLES.AntiseraWorklist.WorklistName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.AutoInstrumentName), TABLES.AntiseraWorklist.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.TestingMethodCode), TABLES.AntiseraWorklist.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.LastUpdateUser), TABLES.AntiseraWorklist.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.RecordStatusCode), TABLES.AntiseraWorklist.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.DivisionCode), TABLES.AntiseraWorklist.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.RowVersion), TABLES.AntiseraWorklist.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistByGuid_Fail()
		{
		}

		[Test]
		public void GetPartiallyCompletedAntiseraWorklists_Pass()
		{
			DataTable dtTest = DAL.AntiseraWorklist.GetPartiallyCompletedAntiseraWorklists();

			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.AntiseraWorklistGuid), TABLES.AntiseraWorklist.AntiseraWorklistGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.WorklistName), TABLES.AntiseraWorklist.WorklistName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.WorklistCreateDate), TABLES.AntiseraWorklist.WorklistCreateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.TestingMethodCode), TABLES.AntiseraWorklist.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.AutoInstrumentName), TABLES.AntiseraWorklist.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.LastUpdateUser), TABLES.AntiseraWorklist.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.RowVersion), TABLES.AntiseraWorklist.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPartiallyCompletedAntiseraWorklists_Fail()
		{
		}

		[Test]
		public void GetAntiseraWorklistDetails_Pass()
		{
			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistDetails(this._antiseraWorklistGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(22, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid), TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid), TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.AntiseraUnitTestGuid), TABLES.AntiseraUnitTest.AntiseraUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.LastUpdateUser), TABLES.AntiseraUnitTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.DivisionCode), TABLES.RackLot.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ControlCellId), TABLES.RackLot.ControlCellId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RowVersion), TABLES.RackLot.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AntiseraUnitTestRowVersion), ARTIFICIAL.AntiseraUnitTestRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistDetails_Fail()
		{
		}

		
		[Test]
		public void GetAntiseraWorklistTypingDetails_Pass()
		{
			System.Guid awtGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];

			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistTypingDetails(awtGuid);


			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid), TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid), TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.AntiseraUnitTestGuid), TABLES.AntiseraUnitTest.AntiseraUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.LastUpdateUser), TABLES.AntiseraUnitTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.DivisionCode), TABLES.RackLot.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ControlCellId), TABLES.RackLot.ControlCellId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistTypingDetails_Fail()
		{
		}


		[Test]
		public void GetAntiseraWorklistUnits_Pass()
		{
			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistUnits(this._antiseraWorklistGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistUnits_Fail()
		{
		}

		[Test]
		public void GetTestResultsForAntiseraWorklist_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			System.Guid awtGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];

			DataTable dtTest = DAL.AntiseraWorklist.GetTestResultsForAntiseraWorklist(unitGuid, awtGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");  
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestResultsForAntiseraWorklist_Fail()
		{
		}

		[Test]
		public void Save_DataSet_Pass()
		{
			this.RefreshData = true;

			DataSet dsTest = new DataSet();
			System.Guid reagentGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			//Done first to get the RackLotGuid
			DataTable dt3 = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			System.Guid antiseraWorklistTypingGuid = System.Guid.NewGuid();
			System.Guid antiseraWorklistGuid = System.Guid.NewGuid();
			System.Guid rackLotGuid = (System.Guid)dt3.Rows[0][TABLES.RackLot.RackLotGuid];

			DataTable dt1 = SprocHelper.GetInsertAntiseraWorklistSprocTable();
			dt1.Rows[0][TABLES.AntiseraWorklist.AntiseraWorklistGuid] = antiseraWorklistGuid;

			DataTable dt2 = SprocHelper.GetInsertAntiseraWorklistTypingSprocTable();
			dt2.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid] = antiseraWorklistGuid;
			dt2.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dt4 = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rackLotGuid);
			dt4.Rows[0][TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dt5 = SprocHelper.GetInsertRackTestSprocTable(System.Guid.NewGuid(), rackLotGuid);

			System.Guid buGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			DataTable dt6 = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), buGuid, 1, "N");

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_antisera_used, "Unit Test 805", Environment.UserName);
			exRep.GenerateExceptionQC(reagentGuid, Guid.Empty, (Guid)_dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid], Guid.Empty, "", "", Common.Utility.GetReactivityPhaseTextFromCode(((int)Common.ReactivityPhase.ThreeSevenandAHG).ToString()), Environment.UserName);
			DataTable dt7 = exRep.ExceptionData.Table.Clone();
			dt7.Rows.Add(exRep.ExceptionData.ItemArray);

			exRep = new BOL.ExceptionReport(Common.ExceptionType.Antigen_testing_phase_change, "Unit Test 805", Environment.UserName);
			exRep.GenerateExceptionUnitTest((Guid)_dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid], _dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString(),"AGwD",Common.Utility.GetReactivityPhaseTextFromCode(((int)Common.ReactivityPhase.ThreeSevenandAHG).ToString()),"",DateTime.Now,Environment.UserName );
			DataTable dt8 = exRep.ExceptionData.Table.Clone();
			dt8.Rows.Add(exRep.ExceptionData.ItemArray);

			System.Guid[] bloodUnitGuids = new System.Guid[1];
			bloodUnitGuids[0] = (Guid)_dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			DataTable dt9 = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases, bloodUnitGuids, Common.WorkloadTransactionType.Unit, false);

			dsTest.Tables.Add(dt1);
			dsTest.Tables.Add(dt2);
			dsTest.Tables.Add(dt3);
			dsTest.Tables.Add(dt4);
			dsTest.Tables.Add(dt5);
			dsTest.Tables.Add(dt6);
			dsTest.Tables.Add(dt7);
			dsTest.Tables.Add(dt8);
			dsTest.Tables.Add(dt9);

			bool retValue = DAL.AntiseraWorklist.Save(dsTest, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnCode");
		}

		[Test]
		[ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void Save_DataSet_Fail()
		{
			DataSet dsTest = new DataSet();
			System.Guid reagentGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			//Done first to get the RackLotGuid
			DataTable dt3 = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			//The existing guids should cause a fail
			System.Guid antiseraWorklistTypingGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];
			System.Guid antiseraWorklistGuid = (System.Guid)this._dtAntiseraWorklist.Rows[0][TABLES.AntiseraWorklist.AntiseraWorklistGuid];
			System.Guid rackLotGuid = (System.Guid)dt3.Rows[0][TABLES.RackLot.RackLotGuid];

			DataTable dt1 = SprocHelper.GetInsertAntiseraWorklistSprocTable();
			dt1.Rows[0][TABLES.AntiseraWorklist.AntiseraWorklistGuid] = antiseraWorklistGuid;

			DataTable dt2 = SprocHelper.GetInsertAntiseraWorklistTypingSprocTable();
			dt2.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid] = antiseraWorklistGuid;
			dt2.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dt4 = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rackLotGuid);
			dt4.Rows[0][TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dt5 = SprocHelper.GetInsertRackTestSprocTable(System.Guid.NewGuid(), rackLotGuid);

			System.Guid buGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			DataTable dt6 = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), buGuid, 1, "N");

			dsTest.Tables.Add(dt1);
			dsTest.Tables.Add(dt2);
			dsTest.Tables.Add(dt3);
			dsTest.Tables.Add(dt4);
			dsTest.Tables.Add(dt5);
			dsTest.Tables.Add(dt6);

			DAL.AntiseraWorklist.Save(dsTest, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void Save_DataTables_Pass()
		{
			this.RefreshData = true;

			DataSet dsTest = new DataSet();
			System.Guid reagentGuid =  (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			System.Guid rackGuid =  (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			
			//Do this first to get the RackLotGuid
			DataTable dtRL = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			//This Save method assumes the WorklistTyping data is already there
			System.Guid antiseraWorklistTypingGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];
			System.Guid antiseraWorklistGuid = (System.Guid)this._dtAntiseraWorklist.Rows[0][TABLES.AntiseraWorklist.AntiseraWorklistGuid];
			System.Guid rackLotGuid = (System.Guid)dtRL.Rows[0][TABLES.RackLot.RackLotGuid];

			DataTable dtAUT = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rackLotGuid);
			dtAUT.Rows[0][TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dtRT = SprocHelper.GetInsertRackTestSprocTable(System.Guid.NewGuid(), rackLotGuid);

			System.Guid buGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			DataTable dtBUT = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), buGuid, 1, "N");

			bool retValue = DAL.AntiseraWorklist.Save(dtRL, dtAUT, dtRT, dtBUT, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnCode");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Save_DataTables_Fail()
		{
			DataSet dsTest = new DataSet();
			System.Guid reagentGuid =  System.Guid.NewGuid();
			System.Guid rackGuid =  System.Guid.NewGuid();
			
			//Do this first to get the RackLotGuid
			DataTable dtRL = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			//New guids should cause fail
			System.Guid antiseraWorklistTypingGuid = System.Guid.NewGuid();
			System.Guid antiseraWorklistGuid = System.Guid.NewGuid();
			System.Guid rackLotGuid = (System.Guid)dtRL.Rows[0][TABLES.RackLot.RackLotGuid];

			DataTable dtAUT = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rackLotGuid);
			dtAUT.Rows[0][TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;

			DataTable dtRT = SprocHelper.GetInsertRackTestSprocTable(System.Guid.NewGuid(), rackLotGuid);

			System.Guid buGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			DataTable dtBUT = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), buGuid, 1, "N");

			DAL.AntiseraWorklist.Save(dtRL, dtAUT, dtRT, dtBUT, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void UpdateTaskStatus_Pass()
		{
			System.Guid worklistGuid = (System.Guid)this._dtAntiseraWorklist.Rows[0][TABLES.AntiseraWorklist.AntiseraWorklistGuid];
			byte[] rowVersion = (byte[])this._dtAntiseraWorklist.Rows[0][TABLES.AntiseraWorklist.RowVersion];

			bool retValue = DAL.AntiseraWorklist.UpdateTaskStatus(worklistGuid, 'I', rowVersion);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateTaskStatus_Fail()
		{
			System.Guid worklistGuid = System.Guid.NewGuid();
			byte[] rowVersion = new byte[8];

			DAL.AntiseraWorklist.UpdateTaskStatus(worklistGuid, 'I', rowVersion);
		}

		[Test]
		public void GetAntiseraWorklistQCResults_Pass()
		{
			System.Guid awtGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];

			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistQCResults(awtGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReagentGuid), TABLES.RackLot.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ControlCellId), TABLES.RackLot.ControlCellId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotVialNumber), TABLES.RackLot.LotVialNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.Comments), TABLES.RackLot.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RowVersion), TABLES.RackTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResultTypeCode), TABLES.RackTest.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.RackLotRowVersion), ARTIFICIAL.RackLotRowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistQCResults_Fail()
		{
		}

		[Test]
		public void GetAntiseraWorklistQCControls_Pass()
		{
			System.Guid awtGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];
			DataTable dtTest = DAL.AntiseraWorklist.GetAntiseraWorklistQCControls(awtGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReagentGuid), TABLES.RackLot.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ControlCellId), TABLES.RackLot.ControlCellId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotVialNumber), TABLES.RackLot.LotVialNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.Comments), TABLES.RackLot.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.RowVersion), TABLES.Reagent.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntiseraWorklistQCControls_Fail()
		{
		}

		[Test]
		public void InvalidateAntigenTypingTestResults_Pass()
		{
			this.RefreshData = true;

			Guid worklistTypingGuid = (Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];
			//
			DataTable dt = new DataTable();
			dt.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid,typeof(Guid));
			DataRow dr = dt.NewRow();
			dr[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = worklistTypingGuid;
			dt.Rows.Add(dr);

			bool retValue = DAL.AntiseraWorklist.InvalidateAntigenTypingTestResults(dt, new DataTable(), Common.UpdateFunction.UnitTests, new DataTable());

			//Set all the data back on success
			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET RecordStatusCode = 'A' WHERE AntiseraWorklistTypingGuid = '" + worklistTypingGuid.ToString() + "'");
				uCheck = UnitTestUtil.RunSQL("UPDATE AntiseraUnitTest SET RecordStatusCode = 'A' WHERE AntiseraWorklistTypingGuid = '" + worklistTypingGuid.ToString() + "'");
				uCheck = UnitTestUtil.RunSQL("UPDATE RackLot SET RecordStatusCode = 'A' WHERE RackLotGUID IN (SELECT RackLot.RackLotGUID FROM RackLot JOIN AntiseraUnitTest ON AntiseraUnitTest.RackLotGUID = RackLot.RackLotGUID WHERE  AntiseraUnitTest.AntiseraWorklistTypingGUID = '" + worklistTypingGuid.ToString() + "')");
				uCheck = UnitTestUtil.RunSQL("UPDATE RackTest SET RecordStatusCode = 'A' WHERE RackLotGUID IN (SELECT RackLot.RackLotGUID FROM RackLot JOIN AntiseraUnitTest ON AntiseraUnitTest.RackLotGUID = RackLot.RackLotGUID WHERE  AntiseraUnitTest.AntiseraWorklistTypingGUID = '" + worklistTypingGuid.ToString() + "')");
			}
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvalidateAntigenTypingTestResults_Fail()
		{
		}

	}
}
#endif
